//	CDeskTop.h

#ifndef _H_CDeskTop
#define _H_CDeskTop

#include "FileSystemTypes.h"
#include "O.h"

class		CFinderWindow;
class		CDesktopWindow;

Boolean		CDesktop_IDesktop(void);
void		CDesktop_Dispose(void);

OSErr		NewDeviceRec(DiskType diskType, void *data, DiskDeviceRec **devicePP);

class CDesktop {
	public:		OSErr	IDesktop(void);
	virtual		void	Dispose(void);
				
				long	GetSpaceUsed(void);
				char	*GetSpaceUsedStr(char *buf);
				
				OSErr	GetDiskImage(DiskImageRec *imageRec);

				OSErr	GetDiskPartition(
					DiskDeviceRec	*deviceP, 
					short			partitionS, 
					CDisk			**diskPP);

				OSErr	MountDisk(
					DiskDeviceRec	*deviceP);

				OSErr	MountPartition(
					DiskDeviceRec	*deviceP, 
					PartitionRec	*partitionRecP, 
					CDisk			**diskPP);

				OSErr		Purge(Boolean criticalB);
				void		SetPendingFlush(void);
				void		DoPendingFlush(void);
				Boolean		IsAlreadyMounted(FSSpec *fsSpecP);

	O_COutline			*i_cOutline;
	CFinderWindow		*i_window;
	CDesktopWindow		*i_desktopWindow;
	Boolean				i_pending_flushB;
};

extern	CDesktop	*gDesktop;

#endif
